/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.workflow;

import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.toolkit.design.property.images.VWImageLoader;
import filenet.vw.toolkit.utils.table.IVWSortItem;
import javax.swing.Icon;

public class VWTableItemWrapper
implements IVWSortItem {
    public static final int TYPE_LOCAL = 0;
    public static final int TYPE_INHERITED = 1;
    public static final int TYPE_OVERRIDDEN = 2;
    private int m_nType = 0;
    private Object m_value = null;
    private Object m_baseValue = null;
    protected Icon m_inheritedIcon = VWImageLoader.createImageIcon("inherited.gif");
    protected Icon m_overriddenIcon = VWImageLoader.createImageIcon("overridden.gif");

    public VWTableItemWrapper(int nType, Object value) throws VWException {
        switch (nType) {
            case 0: 
            case 1: 
            case 2: {
                this.m_nType = nType;
                break;
            }
            default: {
                throw new VWException("vw.toolkit.design.property.workflow.InvalidType", "Invalid type.");
            }
        }
        this.m_value = value;
    }

    public boolean canDelete() {
        return this.m_nType != 1;
    }

    public void deleteOverriddenValue() {
        if (this.m_nType == 2) {
            this.m_value = this.m_baseValue;
            this.m_baseValue = null;
            this.m_nType = 1;
        }
    }

    public Icon getStateIcon() {
        switch (this.m_nType) {
            case 0: {
                return null;
            }
            case 1: {
                return this.m_inheritedIcon;
            }
            case 2: {
                return this.m_overriddenIcon;
            }
        }
        return null;
    }

    public Object getValue() {
        return this.m_value;
    }

    public boolean isInherited() {
        return this.m_nType == 1;
    }

    public boolean isLocal() {
        return this.m_nType == 0;
    }

    public boolean isOverridden() {
        return this.m_nType == 2;
    }

    public void overrideValue(Object newValue) {
        if (this.m_nType == 1) {
            this.m_baseValue = this.m_value;
            this.m_value = newValue;
            this.m_nType = 2;
        }
    }

    public String getName() {
        if (this.m_value != null && this.m_value instanceof VWFieldDefinition) {
            return ((VWFieldDefinition)this.m_value).getName();
        }
        return null;
    }
}

